

class StagedObject:
    __module__ = __name__
    UNKNOWN = -1
    OFF = 0
    ON = 1

    def __init__(self, initState=UNKNOWN):
        self.__state = initState

    def goOnStage(self, *args, **kw):
        if not self.isOnStage():
            self.handleOnStage(*args, **kw)

    def handleOnStage(self):
        self.__state = StagedObject.ON

    def goOffStage(self, *args, **kw):
        if not self.isOffStage():
            self.handleOffStage(*args, **kw)

    def handleOffStage(self):
        self.__state = StagedObject.OFF

    def isOnStage(self):
        return self.__state == StagedObject.ON

    def isOffStage(self):
        return self.__state == StagedObject.OFF