from pandac.PandaModules import *

class GridParent:
    __module__ = __name__
    GridZone2CellOrigin = {}
    GridZone2count = {}

    @staticmethod
    def getCellOrigin(grid, zoneId):
        tup = (grid, zoneId)
        if tup not in GridParent.GridZone2count:
            GridParent.GridZone2count[tup] = 0
            GridParent.GridZone2CellOrigin[tup] = grid.attachNewNode('cellOrigin-%s' % zoneId)
            cellPos = grid.getZoneCellOrigin(zoneId)
            GridParent.GridZone2CellOrigin[tup].setPos(*cellPos)
        GridParent.GridZone2count[tup] += 1
        return GridParent.GridZone2CellOrigin[tup]

    @staticmethod
    def releaseCellOrigin(grid, zoneId):
        tup = (grid, zoneId)
        GridParent.GridZone2count[tup] -= 1
        if GridParent.GridZone2count[tup] == 0:
            GridParent.GridZone2count.pop(tup)
            GridParent.GridZone2CellOrigin.pop(tup).removeNode()

    def __init__(self, child):
        self._child = child
        self._grid = None
        self._zoneId = None
        self.ownCellOrigin = NodePath('cellOrigin')
        self.cellOrigin = self.ownCellOrigin
        return

    def delete(self):
        if self._child and self._child.getParent() == self.cellOrigin:
            self._child.detachNode()
        self._child = None
        if self.ownCellOrigin is not None:
            self.ownCellOrigin.removeNode()
            self.ownCellOrigin = None
        if self._grid is not None:
            self.releaseCellOrigin(self._grid, self._zoneId)
            self._grid = None
            self._zoneId = None
        return

    def getGrid(self):
        return self._grid

    def getGridZone(self):
        return self._zoneId

    def setGridCell(self, grid, zoneId):
        newCellOrigin = self.getCellOrigin(grid, zoneId)
        if self._child.getParent() != newCellOrigin:
            self._child.wrtReparentTo(newCellOrigin)
        else:
            self._child.reparentTo(newCellOrigin)
        if self._grid is not None:
            self.releaseCellOrigin(self._grid, self._zoneId)
        self.cellOrigin = newCellOrigin
        self._grid = grid
        self._zoneId = zoneId
        return