from direct.distributed.DistributedSmoothNodeBase import DistributedSmoothNodeBase
from direct.distributed.GridParent import GridParent
from pandac.PandaModules import EmbeddedValue

class GridChild:
    __module__ = __name__

    def __init__(self):
        try:
            self.__initiallized
        except AttributeError:
            self._gridParent = None
            self._gridInterestEnabled = False
            self._gridInterests = {}

        return

    def delete(self):
        self.__setGridParent(None)
        self.enableGridInterest(False)
        return

    @report(types=['args'], dConfigParam='smoothnode')
    def setGridCell(self, grid, zoneId, updateInterest=False):
        if not hasattr(self, 'getParent'):
            return
        if grid is None:
            self.__setGridParent(None)
            self.__clearGridInterest()
        else:
            hadParent = True
            if not self._gridParent:
                hadParent = False
                self.__setGridParent(GridParent(self))
            self._gridParent.setGridCell(grid, zoneId)
            if updateInterest or hadParent == False:
                self.updateGridInterest(grid, zoneId)
        return

    def updateGridInterest(self, grid, zoneId):
        self.__setGridInterest(grid, zoneId)

    def enableGridInterest(self, enabled=True):
        self._gridInterestEnabled = enabled
        if enabled and self.isOnAGrid():
            for (currGridId, interestInfo) in self._gridInterests.items():
                currGrid = getBase().getRepository().doId2do.get(currGridId)
                if currGrid:
                    self.__setGridInterest(currGrid, interestInfo[1])
                else:
                    self.notify.warning('unknown grid interest %s' % currGridId)

        else:
            self.__clearGridInterest()

    def isOnAGrid(self):
        return self._gridParent is not None

    def getGrid(self):
        if self._gridParent:
            return self._gridParent.getGrid()
        else:
            return
        return

    def getGridZone(self):
        if self._gridParent:
            return self._gridParent.getGridZone()
        else:
            return
        return

    def __setGridParent(self, gridParent):
        if self._gridParent and self._gridParent is not gridParent:
            self._gridParent.delete()
        self._gridParent = gridParent

    def __setGridInterest(self, grid, zoneId):
        if self.cr.noNewInterests():
            self.notify.warning('startProcessVisibility(%s): tried to open a new interest during logout' % self.doId)
            return
        if zoneId < 0 or not grid.isValidZone(zoneId):
            self.notify.warning('__setGridInterest: given bad zoneId [%s] [%s] [%s] [%s] [%s]' % (zoneId, grid, self, str(self.getPos(grid)), str(self._gridInterests)))
            printStack()
            return
        gridDoId = grid.getDoId()
        existingInterest = self._gridInterests.get(gridDoId)
        if self._gridInterestEnabled:
            if existingInterest and existingInterest[0]:
                self.cr.alterInterest(existingInterest[0], grid.getDoId(), zoneId)
                existingInterest[1] = zoneId
            else:
                newInterest = self.cr.addTaggedInterest(gridDoId, zoneId, self.cr.ITAG_GAME, self.uniqueName('gridvis'))
                self._gridInterests[gridDoId] = [newInterest, zoneId]
        else:
            self._gridInterests[gridDoId] = [
             None, zoneId]
        return

    def getGridInterestIds(self):
        return self._gridInterests.keys()

    def getGridInterestReference(self, gridDoId):
        return self._gridInterests.get(gridDoId, [None, None])[0]

    def getGridInterestZoneId(self, gridDoId):
        return self._gridInterests.get(gridDoId, [None, None])[1]

    def clearinGridInterest(self):
        pass

    def __clearGridInterest(self):
        self.clearinGridInterest()
        for (currGridId, interestInfo) in self._gridInterests.items():
            if interestInfo[0]:
                self.cr.removeTaggedInterest(interestInfo[0])

        self._gridInterests = {}

    def checkPosition(self):
        return False


class SmoothGridChild(GridChild):
    __module__ = __name__

    def __init__(self):
        GridChild.__init__(self)

    @report(types=['args'], dConfigParam='smoothnode')
    def setGridCell(self, grid, zoneId, updateInterest=False):
        GridChild.setGridCell(self, grid, zoneId, updateInterest=updateInterest)
        if grid and self.isGenerated():
            self.cnode.setEmbeddedVal(zoneId)

    @report(types=['args'], dConfigParam='smoothnode')
    def updateCurrentZone(self):
        if self.isOnAGrid():
            currGrid = self.getGrid()
            zoneId = currGrid.getZoneFromXYZ(self.getPos(currGrid))
            existingInterest = self._gridInterests.get(currGrid.doId)
            if existingInterest and existingInterest[1] != zoneId:
                self.updateGridInterest(currGrid, zoneId)

    def transformTelemetry(self, x, y, z, h, p, r, e):
        if self.isOnAGrid():
            self.setGridCell(self.getGrid(), e)
        return (x, y, z, h, p, r)