from direct.showbase.DirectObject import DirectObject

class DistributedObjectBase(DirectObject):
    __module__ = __name__
    notify = directNotify.newCategory('DistributedObjectBase')

    def __init__(self, cr):
        self.cr = cr
        self.children = {}
        self.parentId = None
        self.zoneId = None
        return

    def getLocation(self):
        try:
            if self.parentId == 0 and self.zoneId == 0:
                return
            if self.parentId == 4294967295L and self.zoneId == 4294967295L:
                return
            return (
             self.parentId, self.zoneId)
        except AttributeError:
            return

        return

    def handleChildArrive(self, childObj, zoneId):
        pass

    def handleChildArriveZone(self, childObj, zoneId):
        pass

    def handleChildLeave(self, childObj, zoneId):
        pass

    def handleChildLeaveZone(self, childObj, zoneId):
        pass

    def handleQueryObjectChildrenLocalDone(self, context):
        pass

    def getParentObj(self):
        if self.parentId is None:
            return
        return self.cr.doId2do.get(self.parentId)

    def hasParentingRules(self):
        return self.dclass.getFieldByName('setParentingRules') != None

    def getAutoInterests(self):

        def _getAutoInterests(cls):
            if 'autoInterests' in cls.__dict__:
                autoInterests = cls.autoInterests
            else:
                autoInterests = set()
                for base in cls.__bases__:
                    autoInterests.update(_getAutoInterests(base))

                repos = getattr(self, 'cr', getattr(self, 'air'))
                if cls.__name__ in repos.dclassesByName:
                    dclass = repos.dclassesByName[cls.__name__]
                    field = dclass.getFieldByName('AutoInterest')
                    if field is not None:
                        from pandac.PandaModules import DCPacker
                        p = DCPacker()
                        p.setUnpackData(field.getDefaultValue())
                        len = p.rawUnpackUint16() / 4
                        for i in xrange(len):
                            zone = int(p.rawUnpackUint32())
                            autoInterests.add(zone)

                    autoInterests.update(autoInterests)
                    cls.autoInterests = autoInterests
            return set(autoInterests)

        autoInterests = _getAutoInterests(self.__class__)
        if len(autoInterests) > 1:
            self.notify.error('only one auto-interest allowed per DC class, %s has %s autoInterests (%s)' % (self.dclass.getName(), len(autoInterests), list(autoInterests)))
        _getAutoInterests = None
        return list(autoInterests)

    def isGrid(self):
        return 0