from pandac.PandaModules import *
from direct.interval.IntervalGlobal import *
from direct.distributed.DistributedNode import DistributedNode
from direct.task import Task
from direct.gui import DirectGuiGlobals
from direct.showbase.PythonUtil import report
from direct.distributed.StagedObject import StagedObject
from CartesianGridBase import CartesianGridBase
GRID_Z_OFFSET = 0.0

class DistributedCartesianGrid(DistributedNode, CartesianGridBase, StagedObject):
    __module__ = __name__
    notify = directNotify.newCategory('DistributedCartesianGrid')
    notify.setDebug(0)
    VisualizeGrid = config.GetBool('visualize-cartesian-grid', 0)

    def __init__(self, cr):
        DistributedNode.__init__(self, cr)
        CartesianGridBase.__init__(self)
        StagedObject.__init__(self, StagedObject.OFF)

    def disable(self):
        DistributedNode.disable(self)
        CartesianGridBase.disable(self)

    def isGrid(self):
        return CartesianGridBase.isGrid(self)

    def setParentingRules(self, style, rule):
        CartesianGridBase.setParentingRules(self, style, rule)

    def handleChildArrive(self, child, zoneId):
        DistributedNode.handleChildArrive(self, child, zoneId)
        CartesianGridBase.handleChildArrive(self, child, zoneId)

    def handleChildLeave(self, child, zoneId):
        DistributedNode.handleChildLeave(self, child, zoneId)
        CartesianGridBase.handleChildLeave(self, child, zoneId)

    def handleOffStage(self):
        StagedObject.handleOffStage(self)

    def handleOnStage(self, av=None):
        StagedObject.handleOnStage(self)
        if av:
            av.enableGridInterest()

    def validGridInterest(self, child, gridId):
        return child.getGridInterestReference(gridId) != None