import sys
sys.path = ['', 'output']

from pandac.PandaModules import *
from pandac.PandaModules import loadPrcFileData
from direct.directnotify.DirectNotifyGlobal import directNotify
import time, sys, os, __builtin__

# Logging:
notify = directNotify.newCategory('Logger')

ltime = time.localtime()
suffix = '%02d%02d%02d_%02d%02d%02d' % (ltime[0] - 2000, ltime[1], ltime[2], ltime[3], ltime[4], ltime[5])

if not os.path.exists('user/logs/'):
    os.makedirs('user/logs/')

LOGFILE = 'user/logs/' + suffix + '.log'

class LogAndOutput:
    def __init__(self, out, file):
        self.out = out
        self.file = file
        self.__buffer = ''

    def write(self, string):
        self.out.write(string)

        asctime = time.asctime()
        self.__buffer += string
        while '\n' in self.__buffer:
            data, self.__buffer = self.__buffer.split('\n', 1)
            data = data.rstrip()
            if data:
                formatted = '%s: %s\n' % (asctime, data)
                self.file.write(formatted)

        self.flush()

    def flush(self):
        self.file.flush()
        self.out.flush()

file = open(LOGFILE, 'wb')
sys.stdout = LogAndOutput(sys.stdout, file)
sys.stderr = LogAndOutput(sys.stderr, file)

 # Actual launcher class:
class Launcher:
    notify = directNotify.newCategory('Launcher')
    notify.setInfo(True)

    def __init__(self):
        __builtin__.launcher = self

        self.launcherFileDbHash = HashVal()
        self.serverDbFileHash = HashVal()

        launcherConfig = getConfigExpress()
        __builtin__.config = launcherConfig

        vfs = VirtualFileSystem.getGlobalPtr()
        for phaseId in [1, 2, 3, 4, 5, 'WL']:
            vfs.mount(Filename('phase_' + str(phaseId) + '.mf'), '.', VirtualFileSystem.MFReadOnly)

        self.http = HTTPClient()
        self.http.setVerifySsl(0)

        #loadPrcFileData('', 'skip-tutorial #t')
        loadPrcFileData('', 'want-magic-words TRUE')
        loadPrcFileData('', 'fullscreen #f')
        loadPrcFileData('', 'interest-debug 1')
        loadPrcFileData('', 'loading-screen 0')

        self.ServerVersion = 'pcsv1.0.34.31'

        self.startPirates()

    def setPandaErrorCode(self, *args):
        pass

    def getPhaseComplete(self, phase):
        return True # 100

    def setPandaWindowOpen(self, *args):
        pass

    def isDummy(self):
        return False

    def getAccountServer(self):
        return '127.0.0.1'

    def getRegistry(self, key):
        self.notify.info('getRegistry: %s' % (key,))

    def getBlue(self):
        return None

    def getPlayToken(self):
        return None

    def getDISLToken(self):
        return os.getenv('PLAYTOKEN')

    def getNeedPwForSecretKey(self):
        return False

    def getParentPasswordSet(self):
        return True

    def isTestServer(self):
        return False

    def getGameServer(self):
        return '127.0.0.1:7667'

    def setGoUserName(self, *args):
        pass

    def setLastLogin(self, *args):
        pass

    def setUserLoggedIn(self):
        pass

    def setPaidUserLoggedIn(self):
        pass

    def setIsNotNewInstallation(self):
        pass

    def canLeaveFirstIsland(self):
        return True

    def getValue(self, key, default = None):
        return os.getenv(key, default)

    def setValue(self, key, value):
        os.environ[key] = str(value)

    def addPhasePostProcess(self, phase, func, taskChain = 'default'):
        if self.getPhaseComplete(phase):
            func()
            return

        self.acceptOnce('phaseComplete-%s' % phase, func)

    def setDisconnectDetailsNormal(self):
        self.notify.info('setDisconnectDetailsNormal')

        self.disconnectCode = 0
        self.disconnectMsg = 'normal'

    def setDisconnectDetails(self, newCode, newMsg):
        self.notify.info('setDisconnectDetails: %s - %s' % (newCode, newMsg))

        self.disconnectCode = newCode
        self.disconnectMsg = newMsg

    def getServerVersion(self):
        return self.ServerVersion

    def startPirates(self):
        from pirates.piratesbase import PiratesStart

# Start up the launcher:
Launcher()

# Keep Pirates of the Caribbean Online running:
from direct.task.TaskManagerGlobal import taskMgr
taskMgr.run()
